<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete Account Confirmation</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: #121212;
            color: #ffffff;
        }
        .card {
            width: 100%;
            max-width: 400px;
            padding: 20px;
            border-radius: 10px;
            background-color: #1e1e1e;
        }
        .form-control {
            background-color: #2c2c2c;
            color: #ffffff;
            border: 1px solid #444;
        }
        .form-control:focus {
            background-color: #333;
            color: #ffffff;
            border-color: #ff4d4d;
            box-shadow: none;
        }
        .btn-danger {
            background-color: #ff4d4d;
            border: none;
        }
        .btn-danger:hover {
            background-color: #e63939;
        }
    </style>
</head>
<body>

<div class="card">
    <h4 class="text-center text-light">Delete Account</h4>
    <form id="deleteForm" method="POST">
        <div class="mb-3">
            <label for="email" class="form-label text-light">Email</label>
            <input type="email" name="email" class="form-control text-light" id="email" required>
        </div>
        <div class="mb-3">
            <label for="password" class="form-label text-light">Password</label>
            <input type="password" name="password" class="form-control text-light" id="password" required>
        </div>
        <div class="mb-3">
            <label for="confirmation" class="form-label text-light">Type "DELETE_MY_ACCOUNT"</label>
            <input type="text" class="form-control text-light" id="confirmation" required autocomplete="off">
        </div>
        <button type="submit" class="btn btn-danger w-100 text-light" id="submitBtn" style="display: none;">Delete Account</button>
    </form>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const emailInput = document.getElementById("email");
        const passwordInput = document.getElementById("password");
        const confirmationInput = document.getElementById("confirmation");
        const submitBtn = document.getElementById("submitBtn");

        // Prevent paste into the confirmation input field
        confirmationInput.addEventListener("paste", function (event) {
            event.preventDefault();
            alert("Please type manually.");
        });

        function checkInputs() {
            if (
                emailInput.value.trim() !== "" &&
                passwordInput.value.trim() !== "" &&
                confirmationInput.value.trim() === "DELETE_MY_ACCOUNT"
            ) {
                submitBtn.style.display = "block";
            } else {
                submitBtn.style.display = "none";
            }
        }

        emailInput.addEventListener("input", checkInputs);
        passwordInput.addEventListener("input", checkInputs);
        confirmationInput.addEventListener("input", checkInputs);
    });
</script>

</body>
</html>
