<div class="container-fluid">
  <!--  Row 1 -->

  <div class="row">

    <div class="col-lg-12 d-flex align-items-stretch">
      <div class="card w-100">
        <div class="card-body p-4">
                    
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2>Wallet History</h2>
                    <h5 class="text-primary">User Name - <?= htmlspecialchars($user['name']) ?></h5>

                </div>
                
                <a href="<?= site_url('admin/users') ?>" class="btn btn-primary btn-sm mb-3">Back</a>
            </div>


            <table id="wallet_history_table" class="table table-striped table-hover" style="width:100%">
                <thead>
                    <tr>
                        <th>Sr. No</th>
                        <th>Type</th>
                        <th>Coins Changed</th>
                        <th>To Balance</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>

            </div>
      </div>
    </div>
  </div>

<script>
// $(document).ready(function() {
    var t = $('#wallet_history_table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= site_url('admin/users/wallet_history_list/'.$user['id']) ?>",
            "type": "POST"
        },
        "columns": [
            { "data": null, "orderable": false },  // Sr. No will be added manually
            { "data": 0 },
            { "data": 1, "orderable": false },
            { "data": 2, "orderable": false },
            { "data": 3 }
        ],
        "order": [[4, "desc"]],
        pageLength: 25, // Show 50 records by default
        lengthMenu: [ [25,50, 100, 150, 200, 250], [25,50, 100, 150, 200, 250] ],
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            var api = this.api();
            // Display the serial number as (page start + row index + 1)
            var pageInfo = api.page.info();
            $('td:eq(0)', nRow).html(pageInfo.start + iDisplayIndex + 1);
            return nRow;
        }
    });
// });
</script>
