<div class="container-fluid">
  <!--  Row 1 -->

  <div class="row">

    <div class="col-lg-12 d-flex align-items-stretch">
      <div class="card w-100">
        <div class="card-body p-4">
          <h2 class="mb-4">Rewards Settings</h2>
          <div class="table-responsive">
            <table id="example" class="table text-nowrap mb-0 align-middle">
              <thead class="text-dark fs-4">
                <tr>
                  <th class="border-bottom-0">
                    <h6 class="fw-semibold mb-0">User type</h6>
                  </th>

                  <th class="border-bottom-0">
                    <h6 class="fw-semibold mb-0">Rewards Coins</h6>
                  </th>
                  <th class="border-bottom-0">
                    <h6 class="fw-semibold mb-0">Action</h6>
                  </th>
                </tr>
              </thead>
              <tbody>
                <?php foreach($details as $data){ ?>
                  <tr id="row-<?= $data['user_type']; ?>">
                    <td class="border-bottom-0">
                      <h6 class="fw-semibold mb-0">
                        <?= $data['user_type'] === 'regular' ? 'Regular' : 'Partner'; ?>
                      </h6>
                    </td>

                    <td class="border-bottom-0">
                      <input type="text" id="coins-<?= $data['user_type']; ?>" value="<?= $data['reward_coins']; ?>" class="form-control form-control-sm" style="display:none;">
                      <span id="coins-display-<?= $data['user_type']; ?>"><?= $data['reward_coins']; ?></span>
                    </td>

                    <td class="border-bottom-0">
                      <div class="d-flex align-items-center gap-3">
                        <a href="#" class="btn btn-sm btn-warning edit-btn" data-id="<?= $data['user_type']; ?>" data-toggle="tooltip" data-placement="top" title="Edit">
                          <i class="fas fa-edit fa-lg"></i>
                        </a>
                        <button type="button" class="btn btn-success btn-sm save-btn" data-id="<?= $data['user_type']; ?>" style="display:none;"><i class="fa-solid fa-check"></i></button>
                        <button type="button" class="btn btn-secondary btn-sm cancel-btn" data-id="<?= $data['user_type']; ?>" style="display:none;"><i class="fa-solid fa-xmark"></i></button>
                      </div>
                    </td>
                  </tr>
                <?php } ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

  <script>
    $(document).ready(function () {
      let currentEditRowId = null; // Keeps track of the currently editable row

      function disableEditMode(rowId, newCoins) {
        $(`#coins-${rowId}`).hide();
        $(`#coins-display-${rowId}`).text(newCoins).show();
        $(`#row-${rowId} .edit-btn`).show();
        $(`#row-${rowId} .save-btn`).hide();
        $(`#row-${rowId} .cancel-btn`).hide();
      }

      function enableEditMode(rowId) {
        if (currentEditRowId && currentEditRowId !== rowId) {
          const currentId = currentEditRowId;
          const coins = $(`#coins-display-${currentId}`).text();
          disableEditMode(currentId, coins);
        }

        $(`#coins-${rowId}`).show();
        $(`#coins-display-${rowId}`).hide();
        $(`#row-${rowId} .edit-btn`).hide();
        $(`#row-${rowId} .save-btn`).show();
        $(`#row-${rowId} .cancel-btn`).show();

        currentEditRowId = rowId;
      }

      $('.edit-btn').click(function (e) {
        e.preventDefault();
        const id = $(this).data('id');
        enableEditMode(id);
      });

      $('.cancel-btn').click(function () {
        const id = $(this).data('id');
        const coins = $(`#coins-display-${id}`).text();
        disableEditMode(id, coins);
        currentEditRowId = null; // Reset the current editable row
      });

      $('.save-btn').click(function () {
        if (confirm('Do you want to save changes')) {
          const id = $(this).data('id');
          const newCoins = $(`#coins-${id}`).val();

          $.ajax({
            url: "<?= site_url(); ?>/admin/rewards/update_rewards",
            method: 'POST',
            data: {
              user_type: id,
              reward_coins: newCoins
            },
            dataType: 'JSON',
            success: function (response) {
              if (response.status == '1') {
                disableEditMode(id, newCoins);
                currentEditRowId = null; // Reset the current editable row
                success(response.message);
                // Optional: Reload or provide feedback
                // setTimeout(function(){
                //   location.reload();
                // }, 1000);
              }else{
                disableEditMode(id, newCoins);
                currentEditRowId = null; // Reset the current editable row
                error(response.message);
              }
            },
            error: function (error) {
              alert('Error saving data');
            }
          });
        }
      });
    });
  </script>
</div>
