<?php

defined('BASEPATH') or exit('direct script access not allowed');

class Bannermodel extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    protected $table = 'banners';

    public function search_data_where($where)
    {
        $data = $this->db->get_where($this->table, $where)->row_array();

        return $data;
    }

    public function search_mul_data_where($where)
    {
        $data = $this->db
            ->where($where)
            ->order_by('id', 'desc')
            ->get($this->table)->result_array();

        return $data;
    }

    public function save_data($data)
    {

        $insert = $this->db->insert($this->table, $data);

        return $insert;
    }

    public function update_where($data, $where)
    {
        $update = $this->db->set($data)->where($where)->update($this->table);

        return $update;
    }

    public function delete_where($where)
    {
        $delete = $this->db->delete($this->table, $where);

        return $delete;
    }

    public function last_id()
    {

        return $this->db->insert_id();
    }

    var $order = array('id','banner', 'active', 'title', 'paragraph');

    private function _get_data_query($where)
    {
        $this->db->select("$this->table.*");
        $this->db->from($this->table);

        if (isset($_POST['search']['value'])) {
            $searchTerm = $_POST['search']['value'];
            $this->db->group_start();
            $this->db->like('' . $this->table . '.title', $searchTerm);
            // $this->db->or_like('' . $this->table . '.title', $searchTerm);
            $this->db->group_end();
        }

        
        // print_r($_POST);
        $this->db->where($where);
        if (isset($_POST['order'])) {
            $this->db->order_by($this->order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else {

            $this->db->order_by('id', 'desc');
        }
    }

    public function get_data_table($where)
    {
        // print_r($where);exit;
        $this->_get_data_query($where);
        if ($_POST['length'] != -1) {
            $this->db->limit($_POST['length'], $_POST['start']);
        }

        $query = $this->db->get();
        // $b = $query->result_array();
        return $query->result_array();
        print_r($this->db->last_query());
        exit;
    }

    public function count_filtered_data($where)
    {
        $this->_get_data_query($where);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all_data()
    {
        $this->db->from($this->table);
        return $this->db->count_all_results();
    }

    public function log_out($token)
    {

        $this->db->set(['logout_time' => date('Y-m-d H:i:s')])->where(['auth_token' => $token])->update('user_tokens');
    }    

    
  
}
