<?php 

defined('BASEPATH') or exit ('Direct script access not allowed');

require_once APPPATH . "core/My_Admin.php";

class Dashboard extends My_Admin{

    public function __construct()
    {
        parent::__construct();
    }

    public function index() {

        // Count users where register = 1 and deleted = 0
        $data['users'] = $this->db
            ->where('register', '1')
            ->where('deleted', '0')
            ->from('users')
            ->count_all_results();
    
        // Calculate total revenue (only successful payments)
        $query = $this->db->select_sum('amount_paid')
            ->where('payment_status', 'success')
            ->get('store_transaction_history');
        $data['revenue'] = $query->row()->amount_paid ?? 0;
    
        // Get 5 most recently registered users
        $data['new_registered'] = $this->db
            ->where('register', '1')
            ->where('deleted', '0')
            ->order_by('created_at', 'DESC')
            ->limit(5)
            ->get('users')
            ->result();



            // Get today's date (00:00:00 to 23:59:59)
    $today_start = date('Y-m-d 00:00:00');
    $today_end = date('Y-m-d 23:59:59');

    // 1. Total recharge today (sum)
    $recharge_total = $this->db->select_sum('amount_paid')
        ->where('payment_status', 'success')
        ->where('created_at >=', $today_start)
        ->where('created_at <=', $today_end)
        ->get('store_transaction_history')
        ->row()->amount_paid ?? 0;

    // 2. Latest recharge today
    $latest_recharge = $this->db
        ->where('payment_status', 'success')
        ->where('created_at >=', $today_start)
        ->where('created_at <=', $today_end)
        ->order_by('created_at', 'DESC')
        ->limit(1)
        ->get('store_transaction_history')
        ->row();

    $data['today_recharge_total'] = $recharge_total;
    $data['latest_recharge'] = $latest_recharge;
    
        $this->load->view('admin/includes/header', $data);
        $this->load->view('admin/dashboard/view');
        $this->load->view('admin/includes/footer');
    }
    
    
}

?>