<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'welcome';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;




// ADMIN PANEL DATA-TABLE API ROUTES 

$route['admin-get-users-list'] = 'admin/users/view_list';

$route['admin-get-ads-list'] = 'api/admin/ads/view_list';
$route['admin-edit-privacy-policy'] = 'admin/policy/edit';
$route['admin-get-banners-list'] = 'api/admin/banner/view_list';
$route['admin-change-banner-status'] = 'api/admin/banner/change_banner_status';



$route['account-delete'] = 'user/deleteaccount';
$route['account-not-found'] = 'user/deleteaccount/invalid';
$route['account-deleted'] = 'user/deleteaccount/success';


// $route['get-store-credits-list'] = 'api/app/users/get_store_credit_list';



/*
* Auth 
*/
$route['register'] = 'api/app/auth/register';
$route['login'] = 'api/app/auth/login';
$route['social-login'] = 'api/app/auth/social_login';
$route['forgot-password'] = 'api/app/auth/forgot_password';


// * user forgot password - mail 
$route['forgot_password'] = 'admin/changepassword/index';
$route['invalid-request'] = 'admin/changepassword/invalid_request';
$route['change-password-success'] = 'admin/changepassword/change_password_success';


/*
* user
*/
$route['add-referral-code'] = 'api/app/users/add_referral_code';
$route['get-wallet'] = 'api/app/users/get_wallet';
$route['has-rated'] = 'api/app/users/has_rated';
$route['get-user-reward-settings'] = 'api/app/users/get_user_reward_settings';
$route['change-password'] = 'api/app/users/change_password';

$route['get-ads'] = 'api/app/users/get_ads';
$route['watch-ads'] = 'api/app/users/watch_ads';

$route['get-latest-app-version'] = 'api/app/users/get_latest_app_version';
$route['get-payment-key'] = 'api/app/users/get_payment_key';

/*
* services
*/
$route['get-services'] = 'api/app/services/get_services_list';
// $route['request-service'] = 'api/app/services/request_service';
$route['service-request'] = 'api/app/services/service_request';
$route['get-history'] = 'api/app/services/get_history';

$route['create-new-request'] = 'api/app/services/create_new_request';
$route['fetch-requests-to-earn-coins'] = 'api/app/services/fetch_requests_to_earn_coins';
$route['complete-action'] = 'api/app/services/complete_action';
$route['get-user-requests'] = 'api/app/services/get_user_requests';

$route['fetch-all-pending-requests'] = 'api/app/services/fetch_all_pending_requests';
$route['fetch-all-pending-requests-likes'] = 'api/app/services/fetch_all_pending_requests_likes';
$route['fetch-all-pending-requests-subscribe'] = 'api/app/services/fetch_all_pending_requests_subscribe';
/*
* store
*/
$route['get-store-credits-list'] = 'api/app/store/get_store_credit_list';
$route['complete-credit-purchase'] = 'api/app/store/complete_credit_purchase';
$route['get-store-transaction-history'] = 'api/app/store/get_store_transaction_history';


$route['get-spin-wheel'] = 'api/app/store/get_spin_wheel';
$route['get-new-spin'] = 'api/app/store/get_new_spin';
$route['spin-wheel-reward'] = 'api/app/store/spin_wheel_reward';
$route['get-pending-spin-count'] = 'api/app/store/get_pending_spin_count';

// razorpay apis
$route['create-order-razorpay'] = 'RazorpayController/create_order';
$route['verify-payment-razorpay'] = 'RazorpayController/verify_payment';

// welcome offers
$route['get-welcome-offer'] = 'api/app/Users/welcome_offer';
$route['buy-welcome-offer'] = 'api/app/Users/buy_welcome_offer';