<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Social Media</title>
    <link rel="shortcut icon" type="image/png" href="<?= base_url() ?>assets/images/logos/favicon.png" />
    <link rel="stylesheet" href="<?= base_url() ?>assets/css/styles.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- datatable  -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.css" />
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <style>
        .native-toast {
            position: absolute;
            bottom: 0px;
            left: 50%;
            transform: translateX(-50%);
            background-color: rgba(50, 50, 50, 0.8);
            border-radius: 3px;
            color: #fff;
            opacity: 0;
            text-align: center;
            padding: 10px 12px;
            z-index: 99999;
            transition: transform 0.25s, opacity 0.25s, top 0.25s, bottom 0.25s;
            box-sizing: border-box;
            max-width: 18rem;
        }

        .native-toast-error {
            background-color: #ff3d3d;
            color: #fff;
        }

        .native-toast-success {
            background-color: #62a465;
            color: #fff;
        }

        .native-toast-warning {
            background-color: darken(#ffce65, 15);
            color: #fff;
        }

        .native-toast-info {
            background-color: #67daff;
            color: #fff;
        }

        .native-toast-edge {
            border-radius: 0;
            /* max-width: 100%; */
            /* width: 100%; */
            text-align: left;
            /* left: 0; */
            margin: auto;
            border-radius: 15px;
        }

        .native-toast-shown {
            opacity: 1;
            bottom: 50px;
        }

        .custom-tooltip {
            position: relative;
            display: inline-block;
        }
        .has-arrow::after {
            content: "\f107"; /* FontAwesome down arrow */
            font-family: "Font Awesome 5 Free";
            font-weight: 900;
            float: right;
        }

    </style>

</head>

<body>
    <!--  Body Wrapper -->
    <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
        <!-- Sidebar Start -->
        <aside class="left-sidebar">
            <!-- Sidebar scroll-->
            <div>
                <div class="brand-logo d-flex align-items-center justify-content-between">
                    <a href="" class="text-nowrap logo-img">
                        <!-- <img src="../assets/images/logos/dark-logo.svg" width="180" alt="" /> -->
                        <h3>Social Media</h3>
                    </a>
                    <div class="close-btn d-xl-none d-block sidebartoggler cursor-pointer" id="sidebarCollapse">
                        <i class="ti ti-x fs-8"></i>
                    </div>
                </div>
                <!-- Sidebar navigation-->
                <nav class="sidebar-nav scroll-sidebar" data-simplebar="">
                    <ul id="sidebarnav">
                        <li class="nav-small-cap">
                            <i class="ti ti-dots nav-small-cap-icon fs-4"></i>
                            <span class="hide-menu">Home</span>
                        </li>
                        <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/dashboard') ?>" aria-expanded="false">
                                <span>
                                    <i class="ti ti-layout-dashboard"></i>
                                </span>
                                <span class="hide-menu">Dashboard</span>
                            </a>
                        </li>
                        <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/users') ?>" aria-expanded="false">
                                <span>
                                    <i class="ti ti-user"></i>
                                </span>
                                <span class="hide-menu">Users</span>
                            </a>
                        </li>
                        <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/ads') ?>" aria-expanded="false">
                                <span>
                                    <i class="fas fa-ad"></i>
                                </span>
                                <span class="hide-menu">Ads</span>
                            </a>
                        </li>
                        <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/services') ?>" aria-expanded="false">
                                <span>
                                    <i class="fa-solid fa-layer-group"></i>
                                </span>
                                <span class="hide-menu">Services</span>
                            </a>
                        </li>

                        <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/store') ?>" aria-expanded="false">
                                <span>
                                    <i class="fas fa-wrench"></i>
                                </span>
                                <span class="hide-menu">Store</span>
                            </a>
                        </li>

                        <!-- <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/videos') ?>" aria-expanded="false">
                                <span>
                                    <i class="fa-solid fa-film"></i>
                                </span>
                                <span class="hide-menu">Admin Videos</span>
                            </a>
                        </li> -->

                        <li class="sidebar-item">
                            <a class="sidebar-link has-arrow" href="javascript:void(0);" aria-expanded="false">
                                <span>
                                    <i class="fa-solid fa-film"></i>
                                </span>
                                <span class="hide-menu">Admin Videos</span>
                            </a>
                            <ul class="collapse first-level">
                                <li class="sidebar-item">
                                    <a class="sidebar-link" href="<?= site_url('/admin/videos') ?>">
                                        <span><i class="fa-solid fa-caret-right"></i></span>
                                        <!-- <span><i class="fa-solid fa-eye"></i></span> -->
                                        <span class="hide-menu">View</span>
                                    </a>
                                </li>
                                <li class="sidebar-item">
                                    <a class="sidebar-link" href="<?= site_url('/admin/likes') ?>">
                                        <span><i class="fa-solid fa-caret-right"></i></span>
                                        <!-- <span><i class="fa-solid fa-thumbs-up"></i></span> -->
                                        <span class="hide-menu">Likes</span>
                                    </a>
                                </li>
                                <li class="sidebar-item">
                                    <a class="sidebar-link" href="<?= site_url('/admin/subscribe') ?>">
                                        <span><i class="fa-solid fa-caret-right"></i></span>
                                        <!-- <span><i class="fa-solid fa-user-plus"></i></span> -->
                                        <span class="hide-menu">Subscribe</span>
                                    </a>
                                </li>
                            </ul>
                        </li>



                        <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/help') ?>" aria-expanded="false">
                                <span>
                                    <i class="fas fa-question"></i>
                                </span>
                                <span class="hide-menu">Help Center</span>
                            </a>
                        </li>
                        <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/policy') ?>" aria-expanded="false">
                                <span>
                                    <i class="fas fa-shield"></i>
                                </span>
                                <span class="hide-menu">Privacy Policy</span>
                            </a>
                        </li>

                        <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/notification') ?>" aria-expanded="false">
                                <span>
                                    <i class="fa-solid fa-envelope"></i>
                                </span>
                                <span class="hide-menu">Push Notification</span>
                            </a>
                        </li>

                        <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/versions') ?>" aria-expanded="false">
                                <span>
                                    <i class="fa-solid fa-code-compare"></i>
                                </span>
                                <span class="hide-menu">App Version</span>
                            </a>
                        </li>

                        <!-- <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/versions/payment_key') ?>" aria-expanded="false">
                                <span>
                                    <i class="fa-solid fa-code-compare"></i>
                                </span>
                                <span class="hide-menu">Payment Key</span>
                            </a>
                        </li> -->

                        <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/SpinWheel') ?>" aria-expanded="false">
                                <span>
                                    <i class="fa-solid fa-circle-notch"></i>
                                </span>
                                <span class="hide-menu">Spin Wheel</span>
                            </a>
                        </li>

                        <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/rewards') ?>" aria-expanded="false">
                                <span>
                                    <i class="fa-solid fa-award"></i>
                                </span>
                                <span class="hide-menu">Rewards settings</span>
                            </a>
                        </li>
                        <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/discount') ?>" aria-expanded="false">
                                <span>
                                    <i class="fa-solid fa-tags"></i>
                                </span>
                                <span class="hide-menu">Discount</span>
                            </a>
                        </li>
                        <!-- <li class="sidebar-item">
                            <a class="sidebar-link" href="<?= site_url('/admin/sitemap') ?>" aria-expanded="false">
                                <span><i class="fa-solid fa-sitemap"></i></span>
                                <span class="hide-menu">Sitemap</span>
                            </a>
                        </li> -->



                            <!-- <li class="nav-small-cap">
                                <i class="ti ti-dots nav-small-cap-icon fs-4"></i>
                                <span class="hide-menu">AUTH</span>
                            </li>
                            <li class="sidebar-item">
                                <a class="sidebar-link" href="" aria-expanded="false">
                                    <span>
                                        <i class="ti ti-login"></i>
                                    </span>
                                    <span class="hide-menu">Login</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a class="sidebar-link" href="" aria-expanded="false">
                                    <span>
                                        <i class="ti ti-user-plus"></i>
                                    </span>
                                    <span class="hide-menu">Register</span>
                                </a>
                            </li> -->


                    </ul>

                </nav>
                <!-- End Sidebar navigation -->
            </div>
            <!-- End Sidebar scroll-->
        </aside>
        <!--  Sidebar End -->
        <!--  Main wrapper -->
        <div class="body-wrapper">
            <!--  Header Start -->
            <header class="app-header">
                <nav class="navbar navbar-expand-lg navbar-light">
                    <ul class="navbar-nav">
                        <li class="nav-item d-block d-xl-none">
                            <a class="nav-link sidebartoggler nav-icon-hover" id="headerCollapse" href="javascript:void(0)">
                                <i class="ti ti-menu-2"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link nav-icon-hover" href="javascript:void(0)">
                                <i class="ti ti-bell-ringing"></i>
                                <div class="notification bg-primary rounded-circle"></div>
                            </a>
                        </li>
                    </ul>
                    <div class="navbar-collapse justify-content-end px-0" id="navbarNav">
                        <ul class="navbar-nav flex-row ms-auto align-items-center justify-content-end">

                            <li class="nav-item dropdown">
                                <a class="nav-link nav-icon-hover" href="javascript:void(0)" id="drop2" data-bs-toggle="dropdown" aria-expanded="false">
                                    <img src="<?= base_url() ?>assets/images/profile/user-1.jpg" alt="" width="35" height="35" class="rounded-circle">
                                </a>
                                <div class="dropdown-menu dropdown-menu-end dropdown-menu-animate-up" aria-labelledby="drop2">
                                    <div class="message-body">
                                        <a href="javascript:void(0)" class="d-flex align-items-center gap-2 dropdown-item">
                                            <i class="ti ti-user fs-6"></i>
                                            <p class="mb-0 fs-3">My Profile</p>
                                        </a>
                                        <a href="javascript:void(0)" class="d-flex align-items-center gap-2 dropdown-item">
                                            <i class="ti ti-mail fs-6"></i>
                                            <p class="mb-0 fs-3">My Account</p>
                                        </a>
                                        <a href="javascript:void(0)" class="d-flex align-items-center gap-2 dropdown-item">
                                            <i class="ti ti-list-check fs-6"></i>
                                            <p class="mb-0 fs-3">My Task</p>
                                        </a>
                                        <a href="<?= site_url('/welcome/log_out') ?>" class="btn btn-outline-primary mx-3 mt-2 d-block">Logout</a>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </nav>
            </header>
            <!--  Header End -->