<style>
  body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background-color: #f5f7fa;
    color: #333;
  }

  .card {
    border-radius: 10px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    background: #fff;
  }

  .stat-tile {
    padding: 30px 20px;
    text-align: center;
    border-radius: 10px;
    background: #fff;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
    transition: box-shadow 0.3s ease;
  }

  .stat-tile:hover {
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.12);
  }

  .stat-tile h5 {
    font-weight: 600;
    font-size: 1rem;
    color: #555;
    margin-bottom: 10px;
    text-transform: uppercase;
    letter-spacing: 0.05em;
  }

  .stat-tile h2 {
    font-size: 2.2rem;
    font-weight: 700;
    color: #1e2a78;
    margin: 0;
  }

  .table-container {
    padding: 20px;
  }

  table {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0 8px;
  }

  thead th {
    font-weight: 600;
    font-size: 0.9rem;
    color: #555;
    border-bottom: 2px solid #ddd;
    padding: 10px 15px;
    background: #f7f9fc;
    text-align: left;
  }

  tbody tr {
    background: #fff;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.04);
    border-radius: 6px;
    transition: background-color 0.2s ease;
  }

  tbody tr:hover {
    background-color: #eaf0ff;
  }

  tbody td {
    padding: 12px 15px;
    font-size: 1rem;
    color: #444;
  }

  @media (max-width: 767px) {
    .stat-tile h2 {
      font-size: 1.8rem;
    }

    .stat-tile {
      padding: 20px 10px;
    }

    .table-container {
      padding: 15px 10px;
    }
  }
</style>

<div class="container-fluid ">
  <div class="row g-4">
    <!-- Stat Tiles -->
    <div class="col-lg-4 col-md-5 col-sm-12 d-flex flex-column gap-4">
      <div class="stat-tile">
        <h5>Total Users</h5>
        <h2><?= $users ?></h2>
      </div>

      <div class="stat-tile">
        <h5>Total Revenue</h5>
        <h2>₹<?= number_format($revenue, 2) ?></h2>
      </div>

      <div class="stat-tile">
        <h5>Today's Recharge</h5>
        <h2>₹<?= number_format($today_recharge_total ?? 0, 2) ?></h2>
      </div>
    </div>

    <!-- New Registered Users Table -->
    <div class="col-lg-8 col-md-7 col-sm-12">
      <div class="card table-container">
        <h4 class="mb-4 fw-semibold text-primary">New Registered Users</h4>
        <div class="table-responsive">
          <table class="table align-middle">
            <thead>
              <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Registered On</th>
              </tr>
            </thead>
            <tbody>
              <?php if (!empty($new_registered)): ?>
                <?php foreach ($new_registered as $user): ?>
                  <tr>
                    <td><?= htmlspecialchars($user->name) ?></td>
                    <td><?= htmlspecialchars($user->email) ?></td>
                    <td><?= date('d-M-Y', strtotime($user->created_at)) ?></td>
                  </tr>
                <?php endforeach; ?>
              <?php else: ?>
                <tr>
                  <td colspan="3" class="text-center text-muted">No recent registrations found.</td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
