<?php 

defined('BASEPATH') or exit ('Direct script access not allowed');

require_once APPPATH . "core/My_Admin.php";

class Help extends My_Admin{

    public function __construct()
    {
        parent::__construct();
    }

    public $table = 'help_center';


    // * list of help questions 
    public function index(){

        $data['details'] = $this->cm->get();

        $this->load->view('admin/includes/header', $data);
        $this->load->view('admin/help_center/view');
        $this->load->view('admin/includes/footer');

    }

    
    // * create new help question
    public function create(){

        if($this->input->post()){

            // upload_media($_FILES[''])

            $data = $_POST;
            $this->cm->save_data($data);

            $this->session->set_flashdata('success', 'Solution added successfuly.');
            redirect(site_url('/admin/help'));
            
        }

        $this->load->view('admin/includes/header');
        $this->load->view('admin/help_center/create');
        $this->load->view('admin/includes/footer');

    }


    // * edit help question
    public function edit()
    {
        if (isset($_GET['id'])) {
            $id = $_GET['id'];
    
            $query = $this->db->get_where('help_center', ['id' => $id]);
            $data['details'] = $query->row_array();
    
            if (!$data['details']) {
                $this->session->set_flashdata('error', 'Question not found.');
                redirect(site_url('/admin/help'));
            }
    
            if ($this->input->post()) {
                $updateData = [
                    'question' => $this->input->post('question'),
                    'answer'   => $this->input->post('answer'),
                ];
    
                $this->db->where('id', $id);
                $this->db->update('help_center', $updateData);
    
                $this->session->set_flashdata('success', 'Question updated successfully.');
                redirect(site_url('/admin/help'));
            }
    
            $this->load->view('admin/includes/header', $data);
            $this->load->view('admin/help_center/edit', $data);
            $this->load->view('admin/includes/footer');
        } else {
            redirect(site_url('/admin/help'));
        }
    }
    

 
// * delete help question 
public function delete()
{
    if (isset($_GET['id'])) {
        $id = $_GET['id'];

        // Check if the record exists
        $query = $this->db->get_where('help_center', ['id' => $id]);
        $result = $query->row_array();

        if ($result) {
            // Delete the record
            $this->db->where('id', $id);
            $this->db->delete('help_center');

            $this->session->set_flashdata('success', 'Question deleted successfully.');
        } else {
            $this->session->set_flashdata('error', 'Question not found.');
        }

        redirect(site_url('/admin/help'));
    } else {
        $this->session->set_flashdata('error', 'Invalid request.');
        redirect(site_url('/admin/help'));
    }
}


    
}
