<?php 

defined('BASEPATH') or exit ('Direct script access not allowed');

require_once APPPATH . "core/My_Admin.php";

class Ads extends My_Admin{

    public function __construct()
    {
        parent::__construct();
    }

    public $table = 'ads';


    // * advertisement list 
    public function index(){

        $this->load->view('admin/includes/header');
        $this->load->view('admin/ads/view');
        $this->load->view('admin/includes/footer');

    }

    
    // * create new adv
    public function create(){

        if($this->input->post()){

            $data = $_POST;

            $data['thumbnail'] = upload_media($_FILES['thumbnail']);
            $data['file'] = upload_media($_FILES['file']);
            $data['type'] = '2';
            if($_FILES['file']['type'] == 'image/jpeg' || $_FILES['file']['type'] == 'image/jpg' || $_FILES['file']['type'] == 'image/png'){
                $data['type'] = '1';
            }

            $data['created'] = date('Y-m-d H:i:s');

            $this->cm->save_data($data);
            $this->session->set_flashdata('success', 'Ad created successfuly.');
            redirect(site_url('/admin/ads'));
        }

        $this->load->view('admin/includes/header');
        $this->load->view('admin/ads/create');
        $this->load->view('admin/includes/footer');

    }


    // * edit adv
    // public function edit(){

    //     if (isset($_GET['id'])) {

    //         $data['details'] = $this->cm->search_single_where(['id' => $_GET['id']]);

    //         if (empty($data['details'])) {

    //         } else {

    //             if ($this->input->post()) {

    //                 $id = $_GET['id'];
    //                 $data = $_POST;
    //                 $this->session->set_flashdata('success', 'Data updated successfuly.');
    //                 redirect();
    //             }
                
    //             $this->load->view('admin/includes/header', $data);
    //             $this->load->view('admin/ads/edit');
    //             $this->load->view('admin/includes/footer');
    //         }
    //     } else {
            
    //         redirect();
    //     }
        
    // }

    public function edit() {
        $id = $this->input->get('id');
        if (!$id) {
            redirect('/admin/ads');
        }
    
        $ad = $this->db->get_where('ads', ['id' => $id])->row_array();
        if (!$ad) {
            $this->session->set_flashdata('error', 'Ad not found.');
            redirect('/admin/ads');
        }
    
        if ($this->input->post()) {
            $data = $this->input->post();
    
            // echo "<pre>";
            // print_r($data);
            // echo "---";
            // print_r($_FILES);
            // exit;

            // Thumbnail upload
            if (!empty($_FILES['thumbnail']['name'])) {
                $data['thumbnail'] = upload_media($_FILES['thumbnail']);
            } else {
                $data['thumbnail'] = $ad['thumbnail'];
            }
    
            // File upload + type detection
            if (!empty($_FILES['file']['name'])) {
                $data['file'] = upload_media($_FILES['file']);
                $mime = $_FILES['file']['type'];
                $data['type'] = (str_starts_with($mime, 'image/')) ? '1' : '2';
            } else {
                $data['file'] = $ad['file'];
                $data['type'] = $ad['type']; // ✅ Ensure 'type' is set
            }
    
            // Set updated time (optional)
            // $data['updated'] = date('Y-m-d H:i:s');
    
             echo "<br>";
            print_r($data);
            exit;

            // Update DB
            $this->db->where('id', $id)->update('ads', $data);
    
            $this->session->set_flashdata('success', 'Ad updated successfully.');
            redirect('/admin/ads');
        }
    
        $data['details'] = $ad;
        $this->load->view('admin/includes/header', $data);
        $this->load->view('admin/ads/edit', $data);
        $this->load->view('admin/includes/footer');
    }
    
    
    


    // * delete adv
    public function delete() {
        $id = $this->input->get('id');
        if (!$id) {
            redirect('/admin/ads');
        }
    
        $ad = $this->db->get_where('ads', ['id' => $id])->row_array();
    
        if (!$ad) {
            $this->session->set_flashdata('error', 'Ad not found.');
            redirect('/admin/ads');
        }
    
        $this->db->delete('ads', ['id' => $id]);
        $this->session->set_flashdata('success', 'Ad deleted successfully.');
        redirect('/admin/ads');
    }
    
    

    public function view($id = null) {
        if (!$id) {
            redirect('/admin/ads');
        }
    
        $ad = $this->db->get_where('ads', ['id' => $id])->row_array();
    
        if (!$ad) {
            $this->session->set_flashdata('error', 'Ad not found.');
            redirect('/admin/ads');
        }
    
        $data['ad'] = $ad;
        $this->load->view('admin/includes/header');
        $this->load->view('admin/ads/view_single', $data);
        $this->load->view('admin/includes/footer');
    }
    

    
}
