<style>
    td, th {
        vertical-align: bottom !important;
    }
</style>

<div class="container-fluid ">
    <div class="row">
        <div class="col-lg-12 d-flex align-items-stretch">
            <div class="card">
                <div class="card-body p-4">
                    <h2 class="mb-4">Services</h2>

                    <div class="table-responsive mt-3">
                        <table class="table table-hover  text-nowrap">
                            <thead class="text-dark fs-4">
                                <tr>
                                    <th class="border-bottom-0">Sr no</th>
                                    <th class="border-bottom-0">Service Name</th>
                                    <!-- <th class="border-bottom-0 "><h6 class="fw-bold fs-5 mb-0">Service Description</h6></th> -->
                                    <th class="border-bottom-0">Service Code</th>
                                    <th class="border-bottom-0">Coins <sub>(per 100)</sub></th>
                                    <th class="border-bottom-0">Reward Coins</th>
                                    <th class="border-bottom-0">Min Value</th>
                                    <th class="border-bottom-0">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; foreach($details as $data){ ?>
                                    <tr id="row-<?php echo $data['id']; ?>" class="editable-row">
                                        <td class="border-bottom-0"><h6 class="fw-normal mb-0"><?= $i; ?></h6></td>
                                        <td class="border-bottom-0">
                                            <h6 class="fw-normal mb-0"><?= $data['name']; ?></h6>
                                            <input type="text" id="service-desc-<?php echo $data['id']; ?>" value="<?= $data['service_desc']; ?>" class="form-control form-control-sm" style="display:none;">
                                            <span id="service-desc-display-<?php echo $data['id']; ?>"><?= $data['service_desc']; ?></span>
                                        </td>
                                        <!-- <td class="border-bottom-0">
                                            
                                        </td> -->
                                        <td class="border-bottom-0">
                                            <input type="text" id="service-code-<?php echo $data['id']; ?>" value="<?= $data['service_id']; ?>" class="form-control form-control-sm" style="display:none;">
                                            <span id="service-code-display-<?php echo $data['id']; ?>"><?= $data['service_id']; ?></span>
                                        </td>
                                        <td class="border-bottom-0">
                                            <input type="text" id="coins-<?php echo $data['id']; ?>" value="<?= $data['coins']; ?>" class="form-control form-control-sm" style="display:none;">
                                            <span id="coins-display-<?php echo $data['id']; ?>"><?= $data['coins']; ?></span>
                                        </td>
                                        <td class="border-bottom-0">
                                            <input type="text" id="reward-coins-<?php echo $data['id']; ?>" value="<?= $data['reward_coins']; ?>" class="form-control form-control-sm" style="display:none;">
                                            <span id="reward-coins-display-<?php echo $data['id']; ?>"><?= $data['reward_coins']; ?></span>
                                        </td>
                                        <td class="border-bottom-0">
                                            <input type="text" id="min-<?php echo $data['id']; ?>" value="<?= $data['min']; ?>" class="form-control form-control-sm" style="display:none;">
                                            <span id="min-display-<?php echo $data['id']; ?>"><?= $data['min']; ?></span>
                                        </td>
                                        <td class="border-bottom-0">
                                            <div id="action-buttons-<?php echo $data['id']; ?>" class="d-flex align-items-center gap-3">
                                                <a href="#" class="edit-btn btn btn-warning btn-sm" data-id="<?php echo $data['id']; ?>" data-toggle="tooltip" data-placement="top" title="Edit">
                                                    <i class="fas fa-edit fa-lg"></i>
                                                </a>
                                                <button type="button" class="btn btn-success btn-sm save-btn" data-id="<?php echo $data['id']; ?>" style="display:none;"><i class="fa-solid fa-check"></i></button>
                                                <button type="button" class="btn btn-secondary btn-sm cancel-btn" data-id="<?php echo $data['id']; ?>" style="display:none;"><i class="fa-solid fa-xmark"></i></button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php $i++; } ?>
                            </tbody>
                        </table>
                    </div>
                </div>1
            </div>
        </div>
    </div>

<script>
// document.addEventListener('DOMContentLoaded', function() {
    let currentEditRowId = null;

    function disableEditMode(rowId, newServiceCode, newCoins, newRewardCoins, newMin) {
        document.getElementById(`service-desc-${rowId}`).style.display = 'none';
        document.getElementById(`service-code-${rowId}`).style.display = 'none';
        document.getElementById(`coins-${rowId}`).style.display = 'none';
        document.getElementById(`reward-coins-${rowId}`).style.display = 'none';
        document.getElementById(`min-${rowId}`).style.display = 'none';

        document.getElementById(`service-desc-display-${rowId}`).textContent = newServiceCode;
        document.getElementById(`service-code-display-${rowId}`).textContent = newServiceCode;
        document.getElementById(`coins-display-${rowId}`).textContent = newCoins;
        document.getElementById(`reward-coins-display-${rowId}`).textContent = newRewardCoins;
        document.getElementById(`min-display-${rowId}`).textContent = newMin;

        document.getElementById(`service-desc-display-${rowId}`).style.display = 'inline';
        document.getElementById(`service-code-display-${rowId}`).style.display = 'inline';
        document.getElementById(`coins-display-${rowId}`).style.display = 'inline';
        document.getElementById(`reward-coins-display-${rowId}`).style.display = 'inline';
        document.getElementById(`min-display-${rowId}`).style.display = 'inline';

        document.querySelector(`#action-buttons-${rowId} .edit-btn`).style.display = 'inline-block';
        document.querySelector(`#action-buttons-${rowId} .save-btn`).style.display = 'none';
        document.querySelector(`#action-buttons-${rowId} .cancel-btn`).style.display = 'none';
    }

    function enableEditMode(rowId) {
        document.getElementById(`service-desc-${rowId}`).style.display = 'block';
        document.getElementById(`service-code-${rowId}`).style.display = 'block';
        document.getElementById(`coins-${rowId}`).style.display = 'block';
        document.getElementById(`reward-coins-${rowId}`).style.display = 'block';
        document.getElementById(`min-${rowId}`).style.display = 'block';

        document.getElementById(`service-desc-display-${rowId}`).style.display = 'none';
        document.getElementById(`service-code-display-${rowId}`).style.display = 'none';
        document.getElementById(`coins-display-${rowId}`).style.display = 'none';
        document.getElementById(`reward-coins-display-${rowId}`).style.display = 'none';
        document.getElementById(`min-display-${rowId}`).style.display = 'none';

        document.querySelector(`#action-buttons-${rowId} .edit-btn`).style.display = 'none';
        document.querySelector(`#action-buttons-${rowId} .save-btn`).style.display = 'inline-block';
        document.querySelector(`#action-buttons-${rowId} .cancel-btn`).style.display = 'inline-block';

        currentEditRowId = rowId;
    }

    document.querySelectorAll('.edit-btn').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            enableEditMode(this.getAttribute('data-id'));
        });
    });

    document.querySelectorAll('.cancel-btn').forEach(button => {
        button.addEventListener('click', function() {
            disableEditMode(this.getAttribute('data-id'));
            currentEditRowId = null;

            location.reload();

        });
    });

    document.querySelectorAll('.save-btn').forEach(button => {
        button.addEventListener('click', function() {
            if (confirm('Do you want to save changes?')) {
                const id = this.getAttribute('data-id');
                const newServiceDesc = document.getElementById(`service-desc-${id}`).value;
                const newServiceCode = document.getElementById(`service-code-${id}`).value;
                const newCoins = document.getElementById(`coins-${id}`).value;
                const newRewardCoins = document.getElementById(`reward-coins-${id}`).value;
                const newMin = document.getElementById(`min-${id}`).value;

                $.ajax({
                    url: "<?= site_url(); ?>/admin/services/update_service?service_id=" + id,
                    method: 'POST',
                    data: { service_id: newServiceCode, service_desc: newServiceDesc, coins: newCoins, reward_coins: newRewardCoins, min: newMin },
                    dataType: 'JSON',
                    success: function(response) {
                        if (response.status) location.reload();
                    }
                });
            }
        });
    });
// });
</script>
