<?php


defined('BASEPATH') or exit('direct script access not allowed');

class Commonmodel extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function search_single_where($where, $table = null)
    {
        $table = $table ?? $this->table;

        // $data = $this->db->get_where($table, $where)->row_array();

        $data = $this->db->where($where)->order_by('id', 'desc')->get($table)->row_array();

        // print_r($data);exit;

        return $data;
    }


    public function search_multiple_where($where = [], $order = 'DESC', $by = 'id', $table = null)
    {
        $table = $table ?? $this->table;
        $data = $this->db->where($where)->order_by($by, $order)->get($table)->result_array();

        // print_r($this->db->last_query());exit;

        return $data;
    }

    public function get($whereOrData = [], $table = null)
    {

        if(is_array($whereOrData)){

            $where = $whereOrData;

        }else{

           $table = $whereOrData;
           $where = [];
            
        }

        $table = $table ?? $this->table;
        $data = $this->db->where($where)->order_by('id', 'desc')->get($table)->result_array();

        // print_r($this->db->last_query());

        return $data;
    }


    public function select_last_row($select, $table = null)
    {
        $table = $table ?? $this->table;

        $data = $this->db->select($select)->order_by('id', 'desc')->get($table)->row_array();

        // print_r($this->db->last_query());exit;

        return $data;
    }

    public function select_multiple_where($select, $where = [], $order = 'DESC', $by = 'id', $table = null)
    {
        $table = $table ?? $this->table;

        $data = $this->db->select($select)->where($where)->order_by($by, $order)->get($table)->result_array();

        // print_r($this->db->last_query());exit;

        return $data;
    }

    public function select_single_where($select, $where , $table = null)
    {
        $table = $table ?? $this->table;
        
        $data = $this->db->select($select)->get_where($table, $where)->row_array();

        // print_r($data);exit;

        return $data;
    }

    public function save_data($data, $table = null)
    {
        $table = $table ?? $this->table;

        $insert = $this->db->insert($table, $data);

        return $insert;
    }

    public function save_batch($data, $table = null)
    {
        $table = $table ?? $this->table;

        $insert = $this->db->insert_batch($table, $data);

        return $insert;
    }

    public function update_where($data, $where, $table = null)
    {
        $table = $table ?? $this->table;

        $update = $this->db->set($data)->where($where)->update($table);

        return $update;
    }

    public function remove_where($where, $table = null)
    {
        $table = $table ?? $this->table;

        $update = $this->db->set(['remove' => '1'])->where($where)->update($table);

        return $update;
    }

    public function update_all($data, $table)
    {
        $update = $this->db->set($data)->update($table);

        return $update;
    }

    public function delete_where($where, $table = null)
    {
        $table = $table ?? $this->table;
        
        $delete = $this->db->delete($table, $where);

        return $delete;
    }

    public function last_id()
    {
        return $this->db->insert_id();
    }

    public function get_all($table)
    {
        $res = $this->db->order_by('id', 'desc')->get($table)->result_array();
        return $res;
    }

    public function get_data_by_limit($for, $limit, $offset){

        $this->db->select("product_image.image, name, $this->table.id, $this->table.price_inr, $this->table.price_eur, $this->table.price_cad");
        $this->db->join('categories', "categories.id = $this->table.categoryId", 'left');
        $this->db->join('product_details', "$this->table.id = product_details.productId", 'left');
        $this->db->join('product_image', "product_details.id = product_image.productId", 'left');
        $this->db->where(['categories.for' => $for]);
        $this->db->limit($limit, $offset); 
        $this->db->group_by("$this->table.name");
        $this->db->order_by("$this->table.id", 'desc');
        $data = $this->db->get("$this->table")->result_array();

        return $data;

    }


    public function get_auth_token()
    {

        $token = get_token();
        $check = $this->db->get_where('user_tokens', ['auth_token' => $token])->row_array();
        while (!!$check) {
            $token = get_token();
            $check = $this->db->get_where('user_tokens', ['auth_token' => $token]);
        }

        return $token;
    }
}
