<?php

defined('BASEPATH') or exit('deirect script access not allowed');

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

function send_forgot_password_email($receiver_mail, $sender, $sender_password, $sender_username, $code)
{

    require_once APPPATH . 'libraries/vendor/phpmailer/phpmailer/src/Exception.php';
    require_once APPPATH . 'libraries/vendor/phpmailer/phpmailer/src/PHPMailer.php';
    require_once APPPATH . 'libraries/vendor/phpmailer/phpmailer/src/SMTP.php';

    $mail = new PHPMailer;
    $mail->SMTPDebug = 0;
    $mail->isSMTP();
    $mail->Host = "smtp.gmail.com";
    $mail->SMTPAuth = true;
    $mail->Username = $sender;
    $mail->Password = $sender_password;
    $mail->SMTPSecure = "tls";
    $mail->Port = 587;
    $mail->From = $sender;
    $mail->FromName = $sender_username;
    $mail->addAddress($receiver_mail);
    $mail->isHTML(true);
    $mail->Subject = "Reset Your Password";
    $mail->Body = '<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OTP Verification</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f0f5;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .email-container {
            width: 100%;
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
            border: 1px solid #ddd;
        }

        .header {
            background-color:rgb(255, 255, 255);
            text-align: center;
            padding: 0px;
            color: white;
        }

        .header img {
            height: 120px;
        }

        .body {
            padding: 30px;
            text-align: left;
            color: #333;
        }

        .body h1 {
            font-size: 26px;
            color: #333;
            margin-bottom: 10px;
        }

        .body p {
            font-size: 16px;
            color: #555;
            line-height: 1.6;
            margin-bottom: 15px;
        }

        .otp-box {
            margin: 20px 0;
            font-size: 28px;
            font-weight: bold;
            letter-spacing: 4px;
            color: #4caf50;
            background-color: #f9f9f9;
            padding: 12px;
            border-radius: 8px;
            border: 1px dashed #4caf50;
            display: inline-block;
            text-align: center;
        }

        .button {
            display: inline-block;
            padding: 12px 25px;
            font-size: 16px;
            background-color: #4caf50;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            transition: background-color 0.3s;
            font-weight: bold;
        }

        .button:hover {
            background-color: #45a049;
        }

        .footer {
            background-color: #f4f4f4;
            color: #555;
            padding: 20px;
            text-align: center;
            font-size: 14px;
        }

        .footer p {
            margin: 0;
        }

        .footer .contact-info {
            margin-top: 10px;
        }

        .footer .contact-info p {
            margin: 5px 0;
            font-size: 14px;
        }

        @media (max-width: 600px) {
            .body {
                padding: 20px;
            }

            .button {
                font-size: 14px;
            }
        }
    </style>
</head>

<body>

    <div class="email-container">
        <!-- Header -->
        <div class="header">
            <img src="https://updatesbyrobolaxy.com/bot/assets/images/logos/logo.png" alt="Company Logo">
        </div>

        <!-- Body -->
        <div class="body">
            <h1>Reset Your Password</h1>
            <p>We received a request to reset the password for your account. You can change your password by clicking the link below:</p>
            <p> https://updatesbyrobolaxy.com/bot/index.php/forgot_password?i=' . $code .'</p>
            <p>This link will expire in 10 Minutes. If you did not request a password reset, please ignore this email or contact our support team for assistance.</p>
            <p>For security reasons, we recommend that you do not share this email or your password with anyone.</p>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p>Need help? Contact us anytime.</p>
            <div class="contact-info">
                <p>Email: </p>
                <p>Phone: </p>
            </div>
        </div>
    </div>

</body>

</html>
';
    $mail->AltBody = "This is the plain text version of the email content";

    // print_r($mail);
    // exit;

    if (!$mail->send()) {
        echo json_encode([
            'status' => '0',
            'message' => "Mailer Error: " . $mail->ErrorInfo,
            'details' => []
        ]);
    } else {
        echo json_encode([
            'status' => '1',
            'message' => 'Email has been sent successfully',
            'details' => []
        ]);
    }
}
